/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.List;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.framework.storage.sStorageUtil;

public class StorageInfo
implements StorageConstants {
    protected String m_name = null;
    protected String m_node = null;
    protected String m_path = null;
    protected String m_origpath = null;
    protected String m_sign = null;
    protected int m_type = -1;
    protected int m_access;
    protected StorageSize m_size = new StorageSize(0.0, StorageUnit.BYTE);
    protected String m_permissions;
    protected String m_owner;
    protected String m_group;
    protected StorageSize m_free = new StorageSize(-1.0, StorageUnit.BYTE);
    protected sDisk m_sDisk = null;

    public StorageInfo() {
        this.m_access = -1;
    }

    public StorageInfo(String name, String node) {
        this(name, node, null, name, 0);
    }

    protected StorageInfo(String name, String node, String signature) {
        this(name, node, name, signature, 0);
    }

    public StorageInfo(String name, String node, int type) {
        this(name, node, null, name, type);
    }

    public StorageInfo(String name, String node, String path, int type) {
        this(name, node, path, name, type, path);
    }

    public StorageInfo(String name, String node, String path, int type, String origpath) {
        this(name, node, path, name, type, origpath);
    }

    public StorageInfo(String name, String node, String path, int type, String origpath, int access) {
        this(name, node, path, name, type, origpath, access);
    }

    public StorageInfo(String name, String node, String path, String sign, int type) {
        this(name, node, path, sign, type, path);
    }

    public StorageInfo(String name, String node, String path, String sign, int type, String origpath) {
        this(name, node, path, sign, type, path, -1);
    }

    public StorageInfo(String name, String node, String path, String sign, int type, String origpath, int access) {
        this.m_name = name;
        this.m_node = node;
        this.m_path = path;
        this.m_sign = sign;
        this.m_type = type;
        this.m_access = access;
        this.m_origpath = origpath;
    }

    public void set_sDisk(sDisk refsDisk) {
        this.m_sDisk = refsDisk;
    }

    public String getPath() {
        if (null == this.m_path) {
            return this.m_name;
        }
        return this.m_path;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNode() {
        return this.m_node;
    }

    public int getType() {
        return this.m_type;
    }

    public String getOrigPath() {
        if (null == this.m_origpath) {
            return this.getPath();
        }
        return this.m_origpath;
    }

    public StorageSize getSize() {
        return this.m_size;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public String getGroup() {
        return this.m_group;
    }

    public boolean isInGroup(String[] groups) {
        for (String grp : groups) {
            if (!grp.equals(this.m_group)) continue;
            return true;
        }
        return false;
    }

    public String getPermissions() {
        return this.m_permissions;
    }

    public String getSignature() {
        return this.m_sign;
    }

    public int getAccess() {
        return this.m_access;
    }

    public String getTypeStr() {
        return sStorageUtil.getTypeStr(this.m_type);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public void setNode(String node) {
        this.m_node = node;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public void setOrigPath(String origpath) {
        this.m_origpath = origpath;
    }

    public void setSize(StorageSize storageSize) {
        this.m_size = storageSize;
    }

    public void setOwner(String owner) {
        this.m_owner = owner;
    }

    public void setGroup(String group) {
        this.m_group = group;
    }

    public void setPermissions(String permissions) {
        this.m_permissions = permissions;
    }

    public void setFree(StorageSize free) {
        this.m_free = free;
    }

    public void setAccess(int access) {
        this.m_access = access;
    }

    public StorageSize getFree() {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("StorageInfo:getFree(): m_free=" + this.m_free + " ;m_size=" + this.m_size));
        }
        if (this.m_free.compareTo(new StorageSize(-1.0, StorageUnit.BYTE)) != 0) {
            return this.m_free;
        }
        return this.m_size;
    }

    public String toString() {
        return "\nName: " + this.m_name + "\nNode: " + this.m_node + "\nPath: " + this.m_path + "\nOrigPath: " + this.m_origpath + "\nType: " + sStorageUtil.getTypeStr(this.m_type) + "\nSize: " + this.m_size + "\nFree: " + this.m_free + "\nOwner: " + this.m_owner + " Group: " + this.m_group + " Perms: " + this.m_permissions + "\nSignature: " + this.m_sign + "\n";
    }

    public boolean isSharable(List<StorageInfo> stInfoList) {
        if (stInfoList == null || stInfoList.size() == 0) {
            return true;
        }
        for (StorageInfo stInfo : stInfoList) {
            if (this.getType() != 1 && !this.getPath().equalsIgnoreCase(stInfo.getPath())) {
                Trace.out((String)("real path not equal on nodes " + this.getNode() + "," + stInfo.getNode()));
                return false;
            }
            if (!this.getOrigPath().equalsIgnoreCase(stInfo.getOrigPath())) {
                Trace.out((String)("orig path not equal on nodes " + this.getNode() + "," + stInfo.getNode()));
                return false;
            }
            if (this.getType() == stInfo.getType()) continue;
            Trace.out((String)("types don't match on nodes " + this.getNode() + "," + stInfo.getNode()));
            return false;
        }
        Trace.out((String)"all types checkout returning true");
        return true;
    }

    public boolean isPolicySet() {
        return this.m_sDisk != null ? this.m_sDisk.isPolicySet() : false;
    }

    public boolean isLockSet() {
        return this.m_sDisk != null ? this.m_sDisk.isLockSet() : false;
    }
}

